Attribute VB_Name = "mdRectangularDuplicate"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience function to create a rectangular duplicate

Sub RectangularDuplicate(xNumber As Double, yNumber As Double, xSpacing As Double, ySpacing As Double, lineSet As ObjectSet)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

Dim localX As zDirection
Set localX = wp.GetLocalX

Dim localY As zDirection
Set localY = wp.GetLocalY

Rem iterate through the object set and perform the necessary transformation
For I = 0 To (xNumber - 1)
    
    For j = 0 To (yNumber - 1)
sub1:
        If (I = 0 And j = 0) Then
            j = j + 1
            GoTo sub1
        End If
    
        Dim vector1 As zVector
        Set vector1 = localX.Multiply(I * xSpacing)
    
        Dim vector2 As zVector
        Set vector2 = localY.Multiply(j * ySpacing)
    
        Dim transmat As zMatrix
        Set transmat = app.GetClass("Matrix").CreateTranslationMatrix(vector1.Add(vector2))

        duplicatelines sketch, lineSet, transmat

    Next j

Next I

End Sub

Sub duplicatelines(sk As aSketch, objset As ObjectSet, trans)

Dim it As Iterator
Set it = app.GetClass("It").CreateAObjectIt(objset)

Dim obj
Set obj = it.start()

Do While it.IsActive

    Dim curve As zCurve
    Set curve = obj.GetGeometry.Clone
    
    curve.Transform trans
    
    Dim line As aLine
    Set line = sk.CreateLine(curve)
    
    Set obj = it.Next()
    
Loop


End Sub

